#include <iostream>
#include <vector>
#include <algorithm>
#include <utility>

using namespace std;

pair<double, double> prelom(double h1, double x1, double h2, double x2) {
    double p = (h1 + x1 - h2 + x2) / 2.0;
    double y = h1 - (p - x1);
    return {p, y};
}

int main() 
{
    int n;
    cin >> n;

    vector<int> iksovi(n);
    vector<int> visine(n);

    for (int i = 0; i < n; i++) cin >> iksovi[i];
    for (int i = 0; i < n; i++) cin >> visine[i];

    vector<pair<int,int>> parovi(n);
    for (int i = 0; i < n; i++) parovi[i] = {iksovi[i], visine[i]};
    sort(parovi.begin(), parovi.end());

    for (int i = 0; i < n; i++) 
    {
        iksovi[i] = parovi[i].first;
        visine[i] = parovi[i].second;
    }

    for (int i = 0; i < n-1; ++i) 
    {
        double resenje;
        if (visine[i] > visine[i+1]) 
        {
            resenje = -1;
        } 
        else 
        {
            auto tacka = prelom(visine[i], iksovi[i], visine[i+1], iksovi[i+1]);
            if (tacka.second < visine[i])
            {
                tacka.first += visine[i]-tacka.second;
                tacka.second += visine[i]-tacka.second;
            }
            resenje = tacka.first - iksovi[i];
        }
        cout << (int)resenje << endl;
    }
    cout << -1 << endl;

    return 0;
}